import os
import datetime
import operator
from sets import Set
from collections import defaultdict
from video import Video
from settings import SETTINGS


class Show(object):

    def __init__(self, path, duration=None):
        self.path = path

    @staticmethod
    def all():
        paths = Set([os.path.dirname(video.path) for video in Video.all()])
        return [Show(path=path) for path in paths]

    @property
    def duration(self):
        durations = [v.duration for v in Video.all()
                     if v.path.startswith(self.path)]
        return reduce(
            operator.add,
            durations,
            datetime.timedelta(hours=0)
        )

    @property
    def title(self):
        '''
        Show title displayed on the twitch stream
        '''
        title = self.path.split("/")[-1]
        return title.replace('_', ' ').title()

    @property
    def family(self):
        '''
        Show family used to group shows part of the same meta-series
        '''
        return SETTINGS['shows_by_family'].get(self.title, self.title)
