defmodule FollowBeacon.Scraper do
  defstruct streams: []
  # alias Experimental.Flow
  @per_page 100


  def get_all_followers(channel) do
    do_get_followers(channel)
  end

  def do_get_followers(channel,cursor \\ nil) do
    %{"follows" => follows, "_cursor" => cursor } = HTTPoison.get!("https://api.twitch.tv/v5/channels/#{channel}/follows?client_id=ajeucsszlbinfjp4j2o20pwvtvhdwzy&cursor=#{cursor}&limit=100").body
    |> Poison.decode!
    follower_ids = follows
    |> Enum.map(fn(%{"user" => %{ "_id" => id}}) -> id end)
    |> IO.inspect
    case follower_ids do
      [] -> []
      follower_ids -> follower_ids ++ do_get_followers(channel, cursor)
    end
  end


  def get_all_streams() do
    stream_count = HTTPoison.get!("https://api.twitch.tv/v5/streams?client_id=ajeucsszlbinfjp4j2o20pwvtvhdwzy").body
    |> Poison.decode!
    |> Map.get("_total")
    pages_to_fetch = round(stream_count / @per_page) + 1

    0..pages_to_fetch
    |> Flow.from_enumerable(stages: 20, min_demand: 0, max_demand: 1)
    |> Flow.partition
    |> Flow.flat_map(&get_streams/1)
    |> Enum.to_list
    |> Enum.uniq
    |> Enum.map(fn(%{"_id" => id}) -> id end)
    |> Enum.into(%MapSet{})
  end

  def get_streams(offset, limit \\ @per_page) do
    HTTPoison.get!("https://api.twitch.tv/v5/streams?client_id=ajeucsszlbinfjp4j2o20pwvtvhdwzy&limit=#{limit}&offset=#{offset * limit}").body
      |> Poison.decode!
      |> Map.get("streams")
  end

  def get_streams_by_channel(channels) do
    HTTPoison.get!("https://api.twitch.tv/v5/streams", [], params: %{"channel" => Enum.join(channels, ","), "client_id" => "ajeucsszlbinfjp4j2o20pwvtvhdwzy"}).body
      |> Poison.decode!
      |> Map.get("streams")
      |> Enum.map(fn(%{"_id" => id}) -> id end)
      |> Enum.into(%MapSet{})
  end
end
