require 'csv'
#require 'elo'
  
class ResultsController < ActionController::Base
  protect_from_forgery with: :exception

  def results
    @queue = params[:queue]
    @jobs = Job.active.where(:queue => @queue) #.where(:id => [1,20,28])
    @votes = Vote.all.to_a.select { |v| v.is_valid? }

    ratings = {}

    @jobs.map(&:id).each do |id|
      ratings[id] = Elo::Player.new
    end

    matrix = {}

    # get list of jobs that have a vote
    # TODO: how many votes do we need to have enough data?
    @jobs.each do |i|
      wins = Vote.where(:winner => i.id).all.to_a.select { |v| v.is_valid? }.count
      losses = Vote.where(:loser => i.id).all.to_a.select { |v| v.is_valid? }.count
      
      next if (wins + losses) == 0

      matrix[i.id] = {
        :wins => wins,
        :score => 1,
        :matchups => {}
      }
    end

    # get pairwise results
    matrix.keys.each do |i|
      matrix.keys.each do |j|
        next if i == j
        wins = Vote.where(:winner => i, :loser => j).all.to_a.select { |v| v.is_valid? }.count
        losses = Vote.where(:winner => j, :loser => i).all.to_a.select { |v| v.is_valid? }.count

        matrix[i][:matchups][j] = (wins + losses)
      end
    end

    # iterate a few times to get optimal weights
    # http://stats.stackexchange.com/questions/83005/how-to-calculate-ratings-rankings-from-paired-comparison-pairwise-comparison-o
    # http://sites.stat.psu.edu/~dhunter/papers/bt.pdf
    (1..3).each do
      new_weights = {}
      matrix.each do |row|
        id = row.first
        summation = 0
        row.last[:matchups].each do |opponent_id, plays| # KEY = opponent_id. VALUE = number of times played
          summation += (plays.to_f / (matrix[id][:score] + matrix[opponent_id][:score]))
        end
        puts "updating #{id}. wins: #{matrix[id][:wins]}. inverse summation: #{(summation ** -1.0)}"
        new_weights[id] = matrix[id][:wins] == 0 ? 0 : matrix[id][:wins] * (summation ** -1.0)
      end
      new_weights.each do |id, new_score|
        puts "updating #{id} to #{new_score}"
        matrix[id][:score] = new_score
      end
    end

    results = matrix.to_a.sort! do |x, y|
      #y_score = y.last[:score].nan? ? -10000 : y.last[:score]
      #x_score = x.last[:score].nan? ? -10000 : x.last[:score]
      #y_score <=> x_score
      y.last[:score] <=> x.last[:score]
    end

    @results = results.map do |row|
      [Job.find(row.first), row.last[:score]]
    end
  end
end
