class VoteController < ActionController::Base
  protect_from_forgery with: :exception

  layout 'application'

  def view
    @queue = params[:queue]
    @jobs = Job.active.where(:queue => @queue)
    @votes = Vote.where(:voter => session[:name])

    r = Random.new(session[:name].hash + @votes.count)

    if @jobs.count < 2
      puts 'problem!'
      redirect_to '/'
      return
    end

    id1 = r.rand(@jobs.count)
    id2 = nil

    loop do
      id2 = r.rand(@jobs.count)
      break if id2 != id1
    end

    @job_a = @jobs[id1]
    @job_b = @jobs[id2]

    render :vote
  end

  def summary
    @voters = Vote.group(:voter).count
  end

  def vote
    if !session[:name].present?
      redirect_to '/'
      return
    end
    Vote.create!(:winner => params[:winner], :loser => params[:loser], :voter => session[:name])

    redirect_to :back
  end
end
