class Vote < ApplicationRecord
  has_one :winning_job, class_name: "Job", foreign_key: "id", primary_key: "winner"
  has_one :losing_job, class_name: "Job", foreign_key: "id", primary_key: "loser"

  def queue
    winning_job.try(:queue) if winning_job.try(:queue) == losing_job.try(:queue)
  end

  def is_valid?
    winning_job.present? && losing_job.present? && !winning_job.deleted && !losing_job.deleted && winner != loser && queue.present?
  end
end
