import jenkins.model.Jenkins
import javaposse.jobdsl.dsl.helpers.*
import javaposse.jobdsl.dsl.helpers.step.*

proxy = Jenkins.getInstance().proxy

StepContext.metaClass.uploadCreativeBeanstalkApp = { String app, String filename, String account ->
	shell """
aws s3 cp ${filename} s3://elasticbeanstalk-us-west-2-${account}/apps/${app}/\$GIT_COMMIT.zip
aws elasticbeanstalk create-application-version --region us-west-2 --no-auto-create-application --application-name ${app} --version-label \$GIT_COMMIT --source-bundle S3Bucket=elasticbeanstalk-us-west-2-${account},S3Key=apps/${app}/\$GIT_COMMIT.zip
"""
}

StepContext.metaClass.deployCreativeBeanstalkApp = { String app ->
	shell """
pip install awsebcli >/dev/null
mkdir -p .elasticbeanstalk
cat > .elasticbeanstalk/config.yml <<EOF
global:
  application_name: ${app}
  default_region: us-west-2
EOF
eb deploy \$ENVIRONMENT --version \$GIT_COMMIT --timeout 1800 | tee >&1 | grep 'Environment update completed successfully'
"""
}

job {
	name 'creative-jobmash-prod'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'creative/jobmash', 'ssh', 'git.xarth.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	wrappers {
	    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws-creative-beanstalk-creds')
	    }
	}

	steps {
	    shell 'zip -r app.zip .'
	    uploadCreativeBeanstalkApp 'jobmash', 'app.zip', '727894822935'
	}
}

job {
	name 'creative-jobmash-deploy-prod'
	using 'TEMPLATE-deploy'
	wrappers {
		credentialsBinding {
    file('AWS_CONFIG_FILE', 'aws-creative-beanstalk-creds')
		}
	}
	steps {
		deployCreativeBeanstalkApp 'jobmash'
	}
}
