# This file is responsible for configuring your application
# and its dependencies with the aid of the Mix.Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.
use Mix.Config

# General application configuration
config :kv_store,
  ecto_repos: [KvStore.Repo]

# Configures the endpoint
config :kv_store, KvStore.Endpoint,
  url: [host: "localhost"],
  secret_key_base: "ekw424P+HoEH1FC4VRFglPNtQKoUVgmaOm3Q77oA09oefsyuhaAGMWHJS5ukc2xV",
  render_errors: [view: KvStore.ErrorView, accepts: ~w(html json)],
  pubsub: [name: KvStore.PubSub,
           adapter: Phoenix.PubSub.PG2]

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id]

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{Mix.env}.exs"
