defmodule KvStore.Repo.Migrations.CreateChannelProperty do
  use Ecto.Migration

  def change do
    create table(:channel_properties) do
      add :user_id, :integer
      add :commission_button, :boolean, default: false, null: false
      add :commission_text, :string, default: "Hey! I do commissions of all kinds and would love to do a piece of work for you!"

      timestamps()
    end
    create unique_index(:channel_properties, [:user_id])
  end
end
