

module "bs-prod" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-creative-aws"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-0d842869"
  ec2_subnet_ids = "subnet-854b54dc,subnet-3c95594a,subnet-79a40f1d"
  elb_subnet_ids = "subnet-854b54dc,subnet-3c95594a,subnet-79a40f1d"
  elb_loadbalancer_security_groups = "sg-d72913b0"
  auto_scaling_lc_security_groups = "sg-d72913b0"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type = "c4.large"
  owner = "jwahba@twitch.tv"
  service = "creative/kv-store"
  env = "prod"
  associate_public_address = "true"

}
