defmodule KvStore.ChannelPropertyController do
  use KvStore.Web, :controller
  alias KvStore.ChannelProperty

  def show(conn, %{"id" => user_id}) do
    channel_property = Repo.get_by!(ChannelProperty, user_id: user_id)
    render(conn, "show.json", channel_property: channel_property)
  end

  def update(conn, %{"id" => user_id, "channel_property" => channel_property_params}) do
    {user_id, _} = Integer.parse(user_id)
    case current_scopes(conn) do
      %{ "id" => ^user_id} ->
        case ChannelProperty.create_or_update(user_id, channel_property_params) do
          {:ok, channel_property} ->
            render(conn, "show.json", channel_property: channel_property)
          {:error, changeset} ->
            conn
            |> put_status(:unprocessable_entity)
            |> render(KvStore.ChangesetView, "error.json", changeset: changeset)
        end
      _ ->
        conn
        |> put_status(:unauthorized)
        |> render(KvStore.ErrorView, "401.json")
    end
  end

  def current_scopes(conn) do
    conn.req_headers
    |> Enum.find(fn({k,v}) -> k == "x-twitch-user" end)
    |> parse_scope
  end
  def parse_scope(nil), do: nil
  def parse_scope({"x-twitch-user", scope}) do
    scope
    |> Poison.decode!
  end
end
