defmodule KvStore.ChannelProperty do
  use KvStore.Web, :model

  schema "channel_properties" do
    field :user_id, :integer
    field :commission_button, :boolean, default: false
    field :commission_text, :string

    timestamps()
  end

  def create_or_update(user_id, channel_property_params) do
    case KvStore.Repo.get_by(__MODULE__, user_id: user_id) do
      nil ->
        create(user_id, channel_property_params)
      channel_property ->
        channel_property
        |> changeset(channel_property_params)
        |> KvStore.Repo.update()
    end
  end

  def create(user_id, channel_property_params) do
    changeset(%__MODULE__{}, Map.put(channel_property_params, "user_id", user_id))
    |> KvStore.Repo.insert()
  end

  def insert_all(filename) do
    records = File.stream!(filename)
    |> CSV.decode([headers: true])
    |> Enum.map(&(elem(Map.pop(&1, "id"),1)))
    |> Enum.map(&atomize/1)
    KvStore.Repo.insert_all(__MODULE__, records)
  end

  def atomize(map) do
    {user_id, _} = Integer.parse(map["user_id"])
    %{
      user_id: user_id,
      commission_button: map["commission_button"] == "true",
      commission_text: map["commission_text"],
      inserted_at: Ecto.DateTime.utc,
      updated_at: Ecto.DateTime.utc,
    }
  end
  @doc """
  Builds a changeset based on the `struct` and `params`.
  """
  def changeset(struct, params \\ %{}) do
    struct
    |> cast(params, [:user_id, :commission_button, :commission_text])
    |> validate_required([:user_id, :commission_button])
    |> unique_constraint(:user_id)
  end
end
