defmodule KvStore.ChannelPropertyView do
  use KvStore.Web, :view

  @default_commission_text "Hey! I do commissions of all kinds and would love to do a piece of work for you!"
  def render("index.json", %{channel_properties: channel_properties}) do
    %{data: render_many(channel_properties, KvStore.ChannelPropertyView, "channel_property.json")}
  end

  def render("show.json", %{channel_property: channel_property}) do
    %{data: render_one(channel_property, KvStore.ChannelPropertyView, "channel_property.json")}
  end

  def render("channel_property.json", %{channel_property: channel_property}) do
    sanitized_commission_html = sanitize_as_html(channel_property.commission_text)
    %{
      id: channel_property.id,
      user_id: channel_property.user_id,
      commission_button: channel_property.commission_button,
      commission_text: channel_property.commission_text,
      commission_text_html: sanitized_commission_html,
    }
  end
  def sanitize_as_html(commission_text) do
    (commission_text || @default_commission_text)
    |> add_space_after_hashtags
    |> Earmark.as_html!
    |> HtmlSanitizeEx.basic_html
  end

  defp add_space_after_hashtags(string) do
    string = Regex.replace(~r/#([^\#| ])/, string, "# \\g{1}")
    Regex.replace(~r/>/, string, "&nbsp;")
  end
end
