exports.config = {
  npm: {
    styles: {
      "jsoneditor": ['dist/jsoneditor.css'],
      "select2": ['dist/css/select2.css']
    },
    whitelist: ["phoenix", "phoenix_html", "react", "react-dom"]
  },
  // See http://brunch.io/#documentation for docs.
  files: {
    javascripts: {
      joinTo: {
        "js/app.js": /^(static\/js)|(node_modules)/,
        "js/ex_admin_common.js": ["static/vendor/ex_admin_common.js"],
        "js/admin_lte2.js": ["static/vendor/admin_lte2.js"],
        "js/jquery.min.js": ["static/vendor/jquery.min.js"],
      }
    },
    stylesheets: {
      joinTo: {
        "css/app.css": /^(static\/css)/,
        "css/admin_lte2.css": ["static/vendor/admin_lte2.css"],
        "css/active_admin.css.css": ["static/vendor/active_admin.css.css"],
        "css/jsoneditor.css":  ["node_modules/jsoneditor/dist/jsoneditor.css"],
        "css/select2.css":  ["node_modules/select2/dist/css/select2.css"]
      },
      order: {
        after: ["static/css/app.css"] // concat app.css last
      }
    },
    templates: {
      joinTo: "js/app.js"
    }
  },

  conventions: {
    // This option sets where we should place non-css and non-js assets in.
    // By default, we set this to "/static/assets". Files in this directory
    // will be copied to `paths.public`, which is "priv/static" by default.
    assets: /^(static\/assets)/
  },

  // Phoenix paths configuration
  paths: {
    // Dependencies and current project directories to watch
    watched: ["static", "css", "js", "vendor"],

    // Where to compile files to
    public: "../priv/static"
  },

  // Configure your plugins
  plugins: {
    babel: {
      presets: ["env", "stage-2", "react"],
      plugins: ["transform-decorators-legacy"],
      // Do not use ES6 compiler in vendor code
      ignore: [/static\/vendor/]
    }
  },

  modules: {
    autoRequire: {
      "js/app.js": ["static/js/app"]
    }
  }
};
