// Brunch automatically concatenates all files in your
// watched paths. Those paths can be configured at
// config.paths.watched in "brunch-config.js".
//
// However, those files will only be executed if
// explicitly imported. The only exception are files
// in vendor, which are never wrapped in imports and
// therefore are always executed.

// Import dependencies
//
// If you no longer want to use a dependency, remember
// to also remove its path from "config.paths.watched".
import "phoenix_html"
import React from "react"
import ReactDOM from "react-dom"
import "react-phoenix"
import Select2 from 'react-select2-wrapper'
import "./json_stream_schema_editor"
import Scheduler from "./scheduler/scheduler"
import Curator from "./scheduler/curator"
import "./manifest/manifest_form"
import Sequencer from "./asset/sequencer/sequencer"
import "./manager/manager_event_preview"
import "./manager/schedule_selector"
import StartTimes from "./manager/start_times"
import LocalTime from "./manager/local_time"
import ScheduleSelector from "./manager/schedule_selector"

window.Components = {
  StartTimes,
  Select2,
  LocalTime,
  Scheduler,
  ScheduleSelector,
  Curator,
}

let elem = document.getElementById("assetSequence")

if(elem) {
  ReactDOM.render(
    <Sequencer />,
    elem
  )
}

// Import local files
//
// Local files can be imported directly using relative
// paths "./socket" or full ones "web/static/js/socket".

// import socket from "./socket"
