import React, { Component } from 'react';
import PropTypes from 'prop-types';

import { DropTarget } from 'react-dnd';
import ItemTypes from './item_types';
import Box from './box';

const style = {
  height: '900px',
  width: '100%',
  marginRight: '1.5rem',
  marginBottom: '1.5rem',
  padding: '1rem',
  textAlign: 'center',
  fontSize: '1rem',
  lineHeight: 'normal',
  float: 'right',
};

const boxTarget = {
  drop(props, monitor) {
    props.onDrop(monitor.getItem());
    return { name: 'PlayList' };
  },
};

@DropTarget(ItemTypes.BOX, boxTarget, (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isOver: monitor.isOver(),
  canDrop: monitor.canDrop(),
}))

export default class PlayList extends Component {
  static propTypes = {
    connectDropTarget: PropTypes.func.isRequired,
    isOver: PropTypes.bool.isRequired,
    canDrop: PropTypes.bool.isRequired,
  };

  constructor(props) {
    super(props);

    this.state = props;
  }

  render() {
    const { canDrop, isOver, connectDropTarget, items, movePlayListItem, removeFromPlayList} = this.props;
    const isActive = canDrop && isOver;

    let backgroundColor = '#222';
    if (isActive) {
      backgroundColor = 'darkgreen';
    } else if (canDrop) {
      backgroundColor = 'darkkhaki';
    }

    let boxes = items.map((item, index) => {
      return item ? <Box
          key={`playlist_${item.id}`}
          {...item}
          index={index}
          removeItem={removeFromPlayList}
          moveItem={movePlayListItem} /> : null
    });

    return connectDropTarget(
      <div style={{ ...style, backgroundColor }}>
        {boxes}
        What
        {isActive ?
          'Release to drop' :
          'Drag a box here'
        }
      </div>,
    );
  }
}
