import $ from "jquery"
import React from "react"
import ReactDOM from "react-dom"
import JSONEditor from "jsoneditor"
import EventsPreview from "./scheduler/event_preview.js"

class JSONStreamSchemaEditor extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      events: []
    };
  }

  componentDidMount() {
    this.streamSchema();
  }

  streamSchema() {
    return   $.ajax({
      url: `/stream_schedules/${this.props['data-id']}`,
      type: 'GET',
      headers: {
        'Content-Type':'application/json',
        'Accept':'application/json'
      }
    }).then((data) => {
      let container = $('#editor')[0]
      let options = {
        onChange: this.debounce(this.previewStreamSchema.bind(this), 1000)
      }
      let editor = new JSONEditor(container, options);
      editor.set(data.stream_schema)
      editor.expandAll()
      this.setState({
        events: data.events,
        editor: editor
      });
    });
  }

  debounce(func, wait, immediate) {
  	var timeout;
  	return function() {
  		var context = this, args = arguments;
  		var later = function() {
  			timeout = null;
  			if (!immediate) func.apply(context, args);
  		};
  		var callNow = immediate && !timeout;
  		clearTimeout(timeout);
  		timeout = setTimeout(later, wait);
  		if (callNow) func.apply(context, args);
  	};
  }

  previewStreamSchema(){
    let event_preview_length = document.getElementById("input_preview_length").value
    let requestBody = {
      stream_schedule: {
        stream_schema: this.state.editor.get(),
        event_preview_length
      },
      persist: "false"
    }
    $("#input_stream_schema").value = JSON.stringify(this.state.editor.get());
    $.ajax({
      url: `/stream_schedules/${this.props['data-id']}`,
      type: 'PUT',
      headers: {
        'Content-Type':'application/json',
        'Accept':'application/json'
      },
      data: JSON.stringify(requestBody)
    }).then((data)=> {
      this.setState({
        events: data.events,
      });
    })
  }

  render() {
    return (
      <div>
          Preview:
          <div>Schema: <textarea value={this.state.editor && this.state.editor.getText()}></textarea></div>
          <div style={{width: '100%', overflow: 'hidden'}}>
            <div id="editor" style={{height: '1000px', float: 'left', width: '50%'}}></div>
            <div style={{height: '1000px', width: '50%', 'marginLeft': '50%', overflow: 'scroll'}}>
              <EventsPreview tsID={this.props["data-id"]} events={this.state.events} />
            </div>
        </div>
      </div>)
  }

  renderEvent(event) {
    let s3Path = (event.data.asset ?
      <td className="event-path">{event.data.asset.s3_path}</td> : <td></td>)
    let duration = (event.data.asset ?
      <td>{event.data.asset.duration}</td> : <td></td>)
    return(
      <tr className={event.id ? 'success' : 'warning'}>
        <td>{event.inserted_at}</td>
        <td>{event.ref}</td>
        <td  className={event.type === 'play_asset' ? 'info': 'danger'}>{event.type}</td>
        {s3Path}
        {duration}
      </tr>
    )
  }
}


let elem = document.getElementById("preview_table")
if(elem) {
  ReactDOM.render(
    <JSONStreamSchemaEditor data-id={elem.getAttribute("data-id")}/>,
    elem
  )
}
