import $ from "jquery"
import React from "react"
import ReactDOM from "react-dom"

import EventsPreview from "../scheduler/event_preview.js"

class ManagerEventPreview extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      events: props.data.events
    };
  }

  render() {
    return (
      <div style={{width: '100%', height: '100%', overflow: 'scroll'}}>
        <EventsPreview tsID={this.props["data-id"]} events={this.state.events} />
      </div>
    )
  }
}

function fetch_preview(id, length){
  return new Promise((resolve, reject) => {
    $.getJSON({
      url: `/schedule_managers/${id}/preview?length=${length}`,
      type: 'GET',
      headers: {
        'Content-Type':'application/json',
        'Accept':'application/json'
      }
    }, function(data){
      resolve(data);
    }
  )});
}

function get_preview_length(){
  let preview_length = document.getElementById("preview-length").value
  return preview_length > 0 ? parseInt(preview_length) : 15
}

function get_preview(length){
  let preview_table = document.getElementById("manager_preview_table")
  return fetch_preview(preview_table.getAttribute("data-id"), length);
}

let preview_table = document.getElementById("manager_preview_table")
if(preview_table) {
  var manager_preview_ref;
  get_preview(15).then((data) => {
    manager_preview_ref = ReactDOM.render(
      <ManagerEventPreview data={data}/>,
      preview_table
    )
  });
}

$("#refresh-preview").click(function() {
  let preview_length = get_preview_length();
  get_preview(preview_length).then((data) =>
    manager_preview_ref.setState({events: data.events})
  );
});

$("#last-run-button").click(function() {
  $('.manager_preview_table div').animate({
        scrollTop: $(".success:last").offset().top-90
    }, 500);
  return false;
});

$("#first-run-button").click(function() {
  $('.manager_preview_table div').animate({
        scrollTop: $(".success:first").offset().top-90
    }, 500);
  return false;
});
