import React from "react"

export default class ScheduleSelector extends React.Component {
  constructor(props) {
    super(props);

    let {managerID, allSchedules} = props;
    let schedules = allSchedules.filter(schedule => schedule.schedule_manager_id == managerID);
    let inputDisabled = this.handleInputDisabled(allSchedules)
    let selectedSchedule = inputDisabled ? "No free schedules" : "";

    this.state = {
      managerID,
      schedules,
      allSchedules,
      inputDisabled,
      selectedSchedule,
    }

    this.renderSchedules = this.renderSchedules.bind(this);
    this.datalistAllSchedules = this.datalistAllSchedules.bind(this);
    this.addSchedule = this.addSchedule.bind(this);
    this.removeSchedule = this.removeSchedule.bind(this);
    this.handleScheduleInput = this.handleScheduleInput.bind(this);
    this.handleInputDisabled = this.handleInputDisabled.bind(this);
  }


  handleInputDisabled(allSchedules) {
    let freeSchedules = this.datalistAllSchedules(allSchedules);
    return freeSchedules.length < 1
  }

  datalistAllSchedules(allSchedules) {
    return allSchedules.filter(schedule => !schedule.schedule_manager_id).map(schedule => (
      <option key={schedule.name} value={schedule.name} />
    ));
  }

  handleScheduleInput(e) {
    e.preventDefault();
    let selectedSchedule = e.target.value;
    this.setState({ selectedSchedule })
  }

  addSchedule(e) {
    e.preventDefault();
    let { schedules, allSchedules, selectedSchedule } = this.state;
    let alreadyAdded = schedules.find(schedule => schedule.name === selectedSchedule);
    if(alreadyAdded) return this.setState({ selectedSchedule: '' });

    let schedule = allSchedules.find(schedule => schedule.name === selectedSchedule);
    schedule.default_schedule = false;

    this.setState(prevState => {
      prevState.schedules.push(schedule);
      return { selectedSchedule: '' };
    });
  }

  removeSchedule(schedule, e) {
    e.preventDefault();
    if(schedule.default_schedule) {
      if(!confirm("Warning this is a default schedule. Are you sure?")) return;
    }

    this.setState(prevState => {
      schedule.schedule_manager_id = null
      const scheduleIndex = prevState.schedules.findIndex(addedSchedule => addedSchedule.id === schedule.id)
      prevState.schedules.splice(scheduleIndex, 1)
      return prevState;
    })
  }

  renderSchedules() {
    let { schedules } = this.state;
    return schedules.map((schedule, schedule_index) => (
      <tr key={schedule.name}>
        <td><button className="btn btn-danger btn-xs" onClick={this.removeSchedule.bind(this, schedule)}>X</button></td>
        <td><input readOnly type="text" name={`schedule_manager[schedules][${schedule_index}][id]`} value={schedule.id} style={{display: "none"}} />{schedule.id}</td>
        <td><input readOnly type="text" name={`schedule_manager[schedules][${schedule_index}][name]`} value={schedule.name} style={{display: "none"}} /><a href={`/stream_schedules/${schedule.id}/editor`}>{schedule.name}</a></td>
        <td><input readOnly type="text" name={`schedule_manager[schedules][${schedule_index}][start_cron]`} value={schedule.start_cron} style={{display: "none"}} />{schedule.start_cron}</td>
        <td><input readOnly type="text" name={`schedule_manager[schedules][${schedule_index}][duration]`} value={schedule.duration} style={{display: "none"}} />{schedule.duration}</td>
        <td><input readOnly type="text" name={`schedule_manager[schedules][${schedule_index}][state]`} value={schedule.state} style={{display: "none"}} />{schedule.state}</td>
        <td><input type="radio" name={`schedule_manager[default_schedule_id]`} value={schedule.id} defaultChecked={schedule.default_schedule}/></td>
      </tr>
    ))
  }

  render() {
    let createDefaultMessage = this.state.managerID ? undefined : <tr><td className="text-center" colSpan="99">A blank default schedule will be created unless one is selected</td></tr>
    return (
      <div>
        <table className="table">
          <thead>
            <tr>
              <th></th>
              <th>ID</th>
              <th>Schedule Name</th>
              <th>Start Cron</th>
              <th>Duration</th>
              <th>State</th>
              <th>Default</th>
            </tr>
          </thead>
          <tbody>
            {this.renderSchedules()}
            {createDefaultMessage}
          </tbody>
        </table>

        <label>Stream Schedule</label>
        <input type="text" list="schedule_list" value={this.state.selectedSchedule} onChange={this.handleScheduleInput} disabled={this.state.inputDisabled} placeholder="Name"/>
        <datalist id="schedule_list">{this.datalistAllSchedules(this.state.allSchedules)}</datalist>
        <button onClick={this.addSchedule}>Add Schedule</button>
      </div>
    )
  }
}
