import $ from "jquery"
import React from "react"
import ReactDOM from "react-dom"

export default class AssetPreview extends React.Component {
  constructor(props) {
    super(props);
  }

  renderAsset(captionsDropdown, asset, assetIndex) {
    return (
      <tr key={asset}>
        <td><input type="text" name={`asset[${assetIndex}][source_movie]`} value={asset} style={{display: "none"}}/>{asset}</td>
        <td>
          <select name={`asset[${assetIndex}][source_subtitles]`} defaultValue={this.props.selectedCaptions[assetIndex]} onChange={this.props.onCaptionSelected.bind(this, assetIndex)}>
              {captionsDropdown}
          </select>
        </td>
      </tr>
    )
  }

  render() {
    let captionsDefault = [<option value="None_Required" key="None_Required">None_Required</option>, <option value="" key="Order Captions">Order Captions</option>]
    let captionsOptions = this.props.captions.map(caption => (<option value={caption} key={caption}>{caption}</option>));
    let captionsDropdown = captionsDefault.concat(captionsOptions)

    return (

      <div style={{height: '1000px', width: '100%', overflow: 'scroll'}}>
        <div>
          <label>Assets</label>
          <table  className="table">
            <thead className="thead-inverse">
              <tr>
                <th>S3 Path</th>
                <th>Subtitles</th>
              </tr>
            </thead>
            <tbody>{this.props.assets.map(this.renderAsset.bind(this, captionsDropdown))}</tbody>
          </table>
        </div>
      </div>
    )
  }
}
