import $ from "jquery"
import React from "react"
import ReactDOM from "react-dom"
import AssetPreview from "./asset_preview.js"

export default class ManifestForm extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      s3_path: '',
      filters: '',
      name: '',
      assets: [],
      captions: [],
      selectedCaptions: [],
      next: false
    };

    this.handleChange = this.handleChange.bind(this);
    this.onCaptionSelected = this.onCaptionSelected.bind(this);
    this.handleNameChange = this.handleNameChange.bind(this);
    this.handleSubmit = this.handleSubmit.bind(this);
  }

  handleNameChange(event) {
    this.setState({name: event.target.value})
  }

  handleChange(event) {
    this.getObjects(event.target)
  }

  handleSubmit(event) {
    if(this.state.assets.length < 1) {
      if(!confirm("Download an empty csv?")) {
        return event.preventDefault();
      };
    }
    this.setState({next: true})
  }

  getObjects(target) {
    let s3_path = target.name == "s3_path" ? target.value : this.state.s3_path
    let filter_out = target.name == "filter_out" ? target.value : this.state.filters

    return $.ajax({
      url: `/manifests/s3/assets`,
      type: 'GET',
      headers: {
        'Content-Type':'application/json',
        'Accept':'application/json'
      },
      data: { s3_path, filter_out }
    }).then(data => {
      this.setState({assets: data.videos, captions: data.captions, selectedCaptions: data.best_guess, s3_path: s3_path, filters: filter_out})
    }, (err) => {
      console.error(err)
      this.setState({assets: [], captions: [], selectedCaptions: [], s3_path: s3_path, filters: filter_out})
    })
  }

  debounce(func, wait, immediate) {
    var timeout;
    var scope = this;
    return function(event) {
      event.persist();
      var context = this, args = arguments;
      var later = () => {
        timeout = null;
        if (!immediate) func.apply(scope, args);
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) func.apply(scope, args);
    };
  }

  onCaptionSelected(assetIndex, event) {
    this.state.selectedCaptions[assetIndex] = event.target.value;
    this.setState({});
  }

  render() {
    const SHOW_EMPTY = (<div className="form-group"><center><p>It seems there is nothing here. <br/> Try different S3 Path or changing filters</p></center></div>);

    return (
      <div>
        <div className="form-group">
          <label>S3 Path:</label><br/>
          Cosmos Example (remove quotes): "prod_raw/cosmos/"<br/>
          This assumes captions and movies live under the same directory
          <input type="text" name="s3_path" onChange={this.debounce(this.handleChange, 1000).bind(this)} style={{width: '100%'}}></input>
        </div>

        <div className="form-group">
          <label>Filter Out:</label><br/>
          Example (remove quotes): "captions/, h264/" or "extras, test, uncut"
          <input type="text" name="filter_out" onChange={this.debounce(this.handleChange, 1000).bind(this)} style={{width: '100%'}}></input>
        </div>

        <br/>

        <form className="" action="/manifests/s3/csv" method="post" onSubmit={this.handleSubmit}>
          <div className="form-group">
            <label>CSV File Name:</label>
            <input type="text" name="name" onChange={this.handleNameChange} style={{width: '100%'}} required></input>
          </div>

          {this.state.assets.length > 0 ? <AssetPreview assets={this.state.assets} captions={this.state.captions} selectedCaptions={this.state.selectedCaptions} onCaptionSelected={this.onCaptionSelected} /> : SHOW_EMPTY}

          <button className="btn btn-primary" type="submit">Download CSV</button>
        </form>
        <a href="/manifests/new" className={this.state.next ? "btn btn-primary" : "hidden"}>Next Step</a>
      </div>
    )
  }
}

let elem = document.getElementById("manifestS3Input")

if(elem) {
  ReactDOM.render(
    <ManifestForm />,
    elem
  )
}
