import $ from "jquery"
import React from "react"
import CuratedBlock from "./curated_block"
import { DragDropContext, Droppable, Draggable } from 'react-beautiful-dnd';

// a little function to help us with reordering the result
const reorder = (list, startIndex, endIndex) => {
  const result = Array.from(list);
  const [removed] = result.splice(startIndex, 1);
  result.splice(endIndex, 0, removed);

  return result;
};

const remove = (list, index) => {
  const result = Array.from(list);
  result.splice(index, 1);
  return result;
};

// using some little inline style helpers to make the app look okay
const grid = 10;
const getItemStyle = (draggableStyle, isDragging) => ({
  // some basic styles to make the items look a bit nicer
  userSelect: 'none',
  padding: grid * 2,
  margin: `0 0 ${grid}px 0`,

  // change background colour if dragging
  background: isDragging ? 'lightgreen' : '#CBCCCC',

  // styles we need to apply on draggables
  ...draggableStyle,
});
const getListStyle = isDraggingOver => ({
  background: isDraggingOver ? 'lightblue' : 'lightblue',
  padding: grid,
  width: 850
});

export default class Curator extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      queued_event_chunks: props.queued_event_chunks,
      schedule_id: props.schedule_id,
      new_url: ''
    };

    this.onDragEnd = this.onDragEnd.bind(this);
    this.handleInput = this.handleInput.bind(this);
    this.add_new_url = this.add_new_url.bind(this);
    this.make_event_chunk = this.make_event_chunk.bind(this);
    this.save_changes = this.save_changes.bind(this);
    this.do_save_changes = this.do_save_changes.bind(this);
  }

  handleInput(event) {
    const new_url = event.target.value;
    this.setState({ new_url });
  }

  add_new_url(event) {
    this.make_event_chunk(this.state.new_url).done((data) => {
      this.setState({queued_event_chunks: this.state.queued_event_chunks.concat([data])});
    })
    .fail((data) => { alert("Failed to get data for that url. Are you sure it's a video URL?")});
    this.setState({new_url: ''});
  }

  save_changes(event) {
    this.do_save_changes().done((data) => alert("Successfully updated schedule"))
    .fail((data) => alert("Failed to update schedule, bother Theo about it"))
  }

  make_event_chunk(url) {
    let formData = { url }
    return $.getJSON({
        url: `/stream_schedules/${this.state.schedule_id}/create_curated_chunk`,
        type: 'GET',
        headers: {
          'Content-Type':'application/json',
          'Accept':'application/json'
        },
        data: formData
      }, function(data) {
        return data;
      }
    )
  }

  do_save_changes() {
    return $.getJSON({
        url: `/stream_schedules/${this.state.schedule_id}/save_curated_changes`,
        type: 'PUT',
        headers: {
          'Accept':'application/json'
        },
        data: { queued_event_chunks: JSON.stringify(this.state.queued_event_chunks) }
      }, function(data) {
        return data;
      }
    )
  }

  onDragEnd(result) {
    // dropped outside the list
    let queued_event_chunks = this.state.queued_event_chunks
    if (!result.destination) {
      queued_event_chunks = remove(
        this.state.queued_event_chunks,
        result.source.index
      );
    } else {
      queued_event_chunks = reorder(
        this.state.queued_event_chunks,
        result.source.index,
        result.destination.index
      );
    }

    this.setState({queued_event_chunks});
  };

  render() {
     return (
      <div className="curator-table">
        <div className="curator-preview">
        <DragDropContext
          onDragEnd={this.onDragEnd}
        >
          <Droppable droppableId="droppable">
            {(provided, snapshot) => (
              <div
                ref={provided.innerRef}
                style={getListStyle(snapshot.isDraggingOver)}
              >
                {this.state.queued_event_chunks.map(event_chunk => {
                  let index = event_chunk.id
                  return <Draggable key={index} draggableId={index}>
                    {(provided, snapshot) => (
                      <div>
                        <div
                          ref={provided.innerRef}
                          style={getItemStyle(
                            provided.draggableStyle,
                            snapshot.isDragging
                          )}
                          {...provided.dragHandleProps}
                        >
                          <CuratedBlock event_chunk={event_chunk} key={index} />
                        </div>
                        {provided.placeholder}
                      </div>
                    )}
                  </Draggable>
                })}
                {provided.placeholder}
              </div>
            )}
          </Droppable>
        </DragDropContext>
        </div>
        <br />
        <div className="curator-footer">
          <div className="input-group float_left" style={{width: 400}}>
            <input type="text" className="form-control" type="text" name="new_url" value={this.state.new_url} placeholder="New url here" onChange={this.handleInput} />
            <span className="input-group-btn">
              <button className="inline btn btn-default" onClick={this.add_new_url}>Add</button>
            </span>
          </div>
          <div className="float_right">
            <button className="btn btn-success" onClick={this.save_changes}>Save Changes</button>
          </div>
        </div>
      </div>
     );
  }
}
