import React from "react"

const ErrorView = function({ error } = props) {
  let errorRows = error.invalid_rows ? error.invalid_rows.map((row, index) => (
    <tr className="danger" key={index}><td>{row}</td></tr>
  )) : <tr className="danger"></tr>;

  return (
    <table className="table preview-table">
      <thead className="thead-inverse">
        <tr>
          <th>Errors</th>
        </tr>
      </thead>

      <tbody>
        <tr className="danger"><td>{error.message}</td></tr>
        { errorRows }
      </tbody>
    </table>
  )
}

export default ErrorView;
