import React from "react"
import {s3Filename} from "../utils/utils"

export default class Event extends React.Component {
  constructor(props) {
    super(props);
  }

  formatDuration(ms) {
    let min = Math.floor(ms/1000/60)
    let sec = Math.floor((ms - min*60*1000)/1000)
    let time = min + ":" + (sec < 10 ? '0' : '') + sec
    return `${time}`
  }

  render() {
    let event = this.props.event
    let eventIndex = this.key
    let eventClassType = event.type


    // Date crap
    let inserted_at = event.inserted_at || event.projected_inserted_at
    let date = new Date(inserted_at)
    let local_time = (date).toLocaleString()

    // Empty path variables
    let path = ""
    let duration = event.data.duration ? this.formatDuration(event.data.duration) : ""

    switch (event.type) {
      case "play_asset":
        path = <a href={`/assets/${event.data.asset.id}`}>{s3Filename(event.data.asset.s3_path)}</a>
        break
      case "play_commercial":
        path = <a href={`/assets/${event.data.asset.id}`}>{s3Filename(event.data.asset.s3_path)}</a>
        break
      case "play_curated_asset":
        path = <a href={`${event.data.url}`}>{event.data.url}</a>
        break
      case "play_twitch_clip":
        path = <a href={`${event.data.url}`}>twitch.tv/{s3Filename(event.data.chat_data.broadcaster.display_name)}</a>
        break
      default:
        eventClassType = "generic_event"
        break
    }
    return(
      <tr className={event.id ? 'success' : 'warning'} key={eventIndex}>
        <td>{local_time}</td>
        <td className={'event_type'} id={eventClassType}>{event.type}</td>
        <td className="event-path">{path}</td>
        <td>{duration}</td>
        <td>{event.data.index}</td>
      </tr>
    )
  }
}
