import React from "react"
import Event from "./event"

const EventsPreview = function(props) {
  let events = props.events.map((event, index) => {
    return <Event event={event} key={index} />
  })

  return (
    <div>
      <table className="table preview-table">
        <thead className="thead-inverse">
          <tr>
            <th>Run Time</th>
            <th>Event Type</th>
            <th className="event-path">Content (Click For Preview)</th>
            <th>Duration (mm:ss)</th>
            <th>Index</th>
          </tr>
        </thead>
        <tbody>{events}</tbody>
      </table>
    </div>
  )
}


export default EventsPreview;
