import React from "react"
import EventsPreview from "./event_preview.js"
import ErrorView from "./error_view.js"

const IGNORE_FIELDS = ["event_chunks", "events", "played_event_chunks", "queued_event_chunks"];

export default class Scheduler extends React.Component {
  constructor(props) {
    super(props)
    let stream_schedule = JSON.parse(props.stream_schedule);

    this.state = {
      ...stream_schedule,
      csv_schedule: null,
      preview_length: '100',
      error: null,
    }

    this.sendSchedule = this.sendSchedule.bind(this);
    this.handleInputChange = this.handleInputChange.bind(this);
    this.handleToggleChange = this.handleToggleChange.bind(this);
    this.handleFileChange = this.handleFileChange.bind(this);
    this.previewSchedule = this.sendSchedule.bind(this, false);
    this.saveSchedule = this.sendSchedule.bind(this, true);

    this.previewSchedule();
  }

  alertChangesetErrors({responseJSON: { changeset_errors }}) {
    if(!changeset_errors) return;

    let msgs = 'Schedule was not saved because of error saving.';
    for(let prop in changeset_errors) {
      msgs = `${msgs}\n${prop}: ${changeset_errors[prop]}`
    }
    if(status === 500) msgs = msgs + "\nContact an engineer."

    alert(msgs)
  }

  handleFileChange(event) {
    const file = event.target.files[0];
    const name = event.target.name;
    this.setState({[name]: file, error: null}, this.previewSchedule)
  }

  handleInputChange(event) {
    const value = event.target.value;
    const name = event.target.name;
    this.setState({[name]: value})
  }

  handleToggleChange(event) {
    const name = event.target.name;
    const value = this.state[name];
    this.setState({[name]: !value});
  }

  createFormData(state) {
    let formData = new FormData();
    Object.entries(state).forEach(([key, value]) => {
      if(IGNORE_FIELDS.includes(key)) return;
      formData.set(key, value)
    });
    return formData;
  }

  sendSchedule(persist) {
    if(this.state.duration > 2135345634563) return alert("Cannot save or preview, max Duration is 2135345634563");
    let formData = this.createFormData(this.state);
    formData.set('persist', persist);

    return $.ajax({
      url: `/stream_schedules/${this.props.id}`,
      type: 'PUT',
      headers: {
        'Accept':'application/json'
      },
      processData: false,  // tell jQuery not to process the data
      contentType: false,  // tell jQuery not to set contentType
      data: formData
    }).then(data => {
      if(data.saved === "true") alert(`Schedule for ${this.state.name} has been updated`)
      this.setState({ error: null, ...data })
    }, (error) => {
      this.setState({error: error.responseJSON });
      this.alertChangesetErrors(error);
    })
  }

  render() {
    return (
      <div style={{height: '100%'}}>
        <div className="page-header">
          <h2>{this.state.name} <small>Schedule Editor</small></h2>
        </div>

        <div className="row">
          <div className="col-md-4">
            <ul className="list-group">

              <li className="list-group-item">
              <div className="form-group">
                <label htmlFor="name">Schedule Name:</label>
                <input className="form-control" type="text" name="name" value={this.state.name || ''} onChange={this.handleInputChange} />
                <br />
                <label htmlFor="duration">Duration:</label>
                <input className="form-control" type="number" name="duration" value={this.state.duration || ''} onChange={this.handleInputChange} max="2135345634563"/>
                <br />
                <label htmlFor="start_cron">Start Cron:</label>
                <input className="form-control" type="text" name="start_cron" value={this.state.start_cron || ''} onChange={this.handleInputChange} />
                <br />
                <label htmlFor="schedule_manager_id">Schedule Manager ID:</label>
                <input className="form-control" type="number" name="schedule_manager_id" value={this.state.schedule_manager_id || ''} onChange={this.handleInputChange} />
                <br />
                <label htmlFor="state">State:</label>
                <input className="form-control" type="text" name="state" value={this.state.state || ''} onChange={this.handleInputChange} />
                <br />
                <label htmlFor="repeat" className="checkbox-inline">
                  <input type="checkbox" name="repeat" onChange={this.handleToggleChange} checked={this.state.repeat} /> Repeat
                </label>
                <label htmlFor="stop_on_empty" className="checkbox-inline">
                  <input type="checkbox" name="stop_on_empty" onChange={this.handleToggleChange} checked={this.state.stop_on_empty} /> Stop On Empty
                </label>
                <label htmlFor="shuffle" className="checkbox-inline">
                  <input type="checkbox" name="shuffle" onChange={this.handleToggleChange} checked={this.state.shuffle} /> Shuffle
                </label>
              </div>
              </li>

              <li className="list-group-item">
              <div className="form-group">
                <label htmlFor="api_url">API URL:</label>
                <input className="form-control" type="text" name="api_url" value={this.state.api_url || ''} onChange={this.handleInputChange} />
                <br />
                <label htmlFor="api_events_before_replay">Number of Events Before Replay:</label>
                <input className="form-control" type="number" name="api_events_before_replay" value={this.state.api_events_before_replay || ''} onChange={this.handleInputChange} />
                <br />
                <label htmlFor="api_num_days_to_fetch">Number of Days To Fetch From:</label>
                <input className="form-control" type="number" name="api_num_days_to_fetch" value={this.state.api_num_days_to_fetch || ''} onChange={this.handleInputChange} />
              </div>
              </li>

              <li className="list-group-item">
              <div className="form-group">
                <label htmlFor="preview_length">Event Preview Length:</label>
                <input className="form-control" type="number" name="preview_length" value={this.state.preview_length || ''} onChange={this.handleInputChange} />
              </div>
              </li>

              <li className="list-group-item">
                <div className="form-group">
                  <label htmlFor="csv_schedule">Upload CSV:</label>
                  <input className="form-control" type="file" name="csv_schedule" onChange={this.handleFileChange} accept=".csv" style={{display: "inline-block"}} />
                </div>
              </li>
            </ul>
          </div>
          <div className="col-md-8">
            <div style={{height: '1000px', overflow: 'scroll'}}>
              {this.state.error ?  <ErrorView error={this.state.error} /> : <EventsPreview tsID={this.props.tsID} events={this.state.events} /> }
            </div>
          </div>
        </div>

        <div>
          <button onClick={this.previewSchedule}>Preview</button>
          <button onClick={this.saveSchedule}>Save</button>
        </div>
      </div>
    )
  }
}
