export function debounce(func, wait, immediate) {
  var timeout;
  return function() {
    var context = this, args = arguments;
    var later = function() {
      timeout = null;
      if (!immediate) func.apply(context, args);
    };
    var callNow = immediate && !timeout;
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
    if (callNow) func.apply(context, args);
  };
};

export function s3Filename(s3Path, delimiter = "/") {
  return s3Path.substr(s3Path.lastIndexOf(delimiter)+1);
}

const utils = { debounce, s3Filename };

export default utils;
