# This file is responsible for configuring your application
# and its dependencies with the aid of the Mix.Config module.
#
# This configuration file is loaded before any dependency and
# is restricted to this project.
use Mix.Config

config :mission_control_ex,
  ecto_repos: [MissionControlEx.Web.Repo],
  twitch_delay: 15_000,
  media_path: "/media/tmp"

# Configures the endpoint
config :mission_control_ex, MissionControlEx.Web.Endpoint,
  url: [host: "localhost"],
  secret_key_base: "RbVk1O/nGgwC/kbl4h2apg7PKYkC8jCzNYO8mz+PExmlyc+DdSVHU9/VPhreN9vD",
  render_errors: [view: MissionControlEx.Web.ErrorView, accepts: ~w(html json)],
  pubsub: [name: MissionControlEx.Web.PubSub,
           adapter: Phoenix.PubSub.PG2]

# Configures Elixir's Logger
config :logger, :console,
  format: "$time $metadata[$level] $message\n",
  metadata: [:request_id, :file, :module, :function, :line, :id, :twitch_stream, :channel, :airing]

config :ex_aws,
  access_key_id: [{:awscli, "twitch-creative-aws", 30}, {:system, "AWS_ACCESS_KEY_ID"}, :instance_role],
  secret_access_key: [{:awscli, "twitch-creative-aws", 30}, {:system, "AWS_SECRET_ACCESS_KEY"}, :instance_role],
  region: "us-west-2"

config :mission_control_ex, MissionControlEx.Web.Repo,
  adapter: Ecto.Adapters.Postgres,
  database: "mission_control_ex_#{Mix.env}_db",
  username: "postgres",
  password: "postgres",
  hostname: "localhost",
  pool_size: 10

config :briefly,
  directory: ["/media"],
  default_prefix: "briefly",
  default_extname: ""

config :rollbax,
  access_token: "a04307c9dd6d4bc8bea734d8c4f67ff5",
  environment: Mix.env


config :logger,
  backends: [Rollbax.Logger, :console],
  truncate: :infinity

# We configure the Rollbax.Logger backend.
config :logger, Rollbax.Logger,
  level: :error,
  metadata: [:file, :module, :function, :line, :id, :twitch_stream, :channel, :airing]

config :logger, :console,
  format: "$time $metadata[$level] $levelpad$message\n",
  metadata: [:module, :function, :line, :id, :twitch_stream, :channel, :airing],
  level: :info

config :ueberauth, Ueberauth,
  providers: [
    twitchtv: {Ueberauth.Strategy.TwitchTv, [default_scope: "user_read user_blocks_edit user_blocks_read user_follows_edit channel_read channel_editor channel_commercial channel_stream channel_subscriptions user_subscriptions channel_check_subscription chat_login"]}
  ]

# Import environment specific config. This must remain at the bottom
# of this file so it overrides the configuration defined above.
import_config "#{Mix.env}.exs"
