use Mix.Config

# For development, we disable any cache and enable
# debugging and code reloading.
#
# The watchers configuration can be used to run external
# watchers to your application. For example, we use it
# with brunch.io to recompile .js and .css sources.
config :mission_control_ex,
  media_path: "#{File.cwd!}/media/tmp",
  event_api_url: "localhost:4000"

config :mission_control_ex, MissionControlEx.Web.Endpoint,
  http: [port: 4000],
  debug_errors: true,
  code_reloader: true,
  check_origin: false,
  watchers: [node: ["node_modules/brunch/bin/brunch", "watch", "--stdin",
                    cd: Path.expand("../assets", __DIR__)]]

# Watch static and templates for browser reloading.
config :mission_control_ex, MissionControlEx.Web.Endpoint,
  live_reload: [
    patterns: [
      ~r{priv/static/.*(js|css|png|jpeg|jpg|gif|svg)$},
      ~r{priv/gettext/.*(po)$},
      ~r{lib/mission_control_ex/web/views/.*(ex)$},
      ~r{lib/mission_control_ex/web/templates/.*(eex)$}
    ]
  ]

# config :mission_control_ex, MissionControlEx.Web.Repo,
#   adapter: Ecto.Adapters.Postgres,
#   database: "mission_control_ex_staging_db",
#   username: "missioncontrol",
#   password: "missioncontrol",
#   hostname: "missioncontrol.cokyctnqdzct.us-west-2.rds.amazonaws.com",
#   pool_size: 10

# Do not include metadata nor timestamps in development logs
config :logger, :console, format: "[$level] $metadata\n  $message\n", level: :info,
  metadata: [:stream, :schedule, :channel, :airing]

# Set a higher stacktrace during development. Avoid configuring such
# in production as building large stacktraces may be expensive.
config :phoenix, :stacktrace_depth, 20

config :ex_aws,
  access_key_id: [{:awscli, "twitch-creative-aws", 30}, :instance_role],
  secret_access_key: [{:awscli, "twitch-creative-aws", 30}, :instance_role]

# config :rollbax,
#   access_token: "a04307c9dd6d4bc8bea734d8c4f67ff5",
#   environment: Mix.env,
#   enabled: :log

config :ueberauth, Ueberauth.Strategy.TwitchTv.OAuth,
  client_id: "ed7jdo1lvww4g5d5laey5nr6funh31",
  client_secret: "37fsp5if3wveknpkrmt3si7t9qgl1b"
