use Mix.Config

# For production, we configure the host to read the PORT
# from the system environment. Therefore, you will need
# to set PORT=80 before running your server.
#
# You should also configure the url host to something
# meaningful, we use this information when generating URLs.
#
# Finally, we also include the path to a manifest
# containing the digested version of static files. This
# manifest is generated by the mix phoenix.digest task
# which you typically run after static files are built.
config :mission_control_ex, MissionControlEx.Web.Endpoint,
  http: [port: {:system, "PORT"}],
  url: [host: "example.com", port: 80],
  cache_static_manifest: "priv/static/cache_manifest.json"

config :mission_control_ex,
  event_api_url: "http://prod-creative-mission-control-ex-env.gpyvarfsbb.us-west-2.elasticbeanstalk.com/"

# ## SSL Support
#
# To get SSL working, you will need to add the `https` key
# to the previous section and set your `:url` port to 443:
#
#     config :mission_control_ex, MissionControlEx.Web.Endpoint,
#       ...
#       url: [host: "example.com", port: 443],
#       https: [port: 443,
#               keyfile: System.get_env("SOME_APP_SSL_KEY_PATH"),
#               certfile: System.get_env("SOME_APP_SSL_CERT_PATH")]
#
# Where those two env variables return an absolute path to
# the key and cert in disk or a relative path inside priv,
# for example "priv/ssl/server.key".
#
# We also recommend setting `force_ssl`, ensuring no data is
# ever sent via http, always redirecting to https:
#
#     config :mission_control_ex, MissionControlEx.Web.Endpoint,
#       force_ssl: [hsts: true]
#
# Check `Plug.SSL` for all available options in `force_ssl`.

# ## Using releases
#
# If you are doing OTP releases, you need to instruct Phoenix
# to start the server for all endpoints:
#
#     config :phoenix, :serve_endpoints, true
#
# Alternatively, you can configure exactly which server to
# start per endpoint:
#
#     config :mission_control_ex, MissionControlEx.Web.Endpoint, server: true
#

config :mission_control_ex, MissionControlEx.Web.Repo,
  adapter: Ecto.Adapters.Postgres,
  database: "mission_control_ex_prod_db",
  username: "mission_control",
  password: "mission-control",
  hostname: "mission-control.cb4e8mq1i2ik.us-west-2.rds.amazonaws.com",
  pool_size: 10
# Finally import the config/prod.secret.exs
# which should be versioned separately.



config :libcluster,
  topologies: [
    beanstalk_example: [
      strategy: BeanstalkGossipStrategy,
      config: [
        app_name: "streamer",
        beanstalk_environments: ["prod-creative-mission-control-ex-env", "prodW-creative-mission-control-ex-env"],
        polling_interval: 60_000]]]


config :ueberauth, Ueberauth.Strategy.TwitchTv.OAuth,
  client_id: "rof4xchhpg7mp8kiz2v9ctqhw5r4m1o",
  client_secret: "vk5esudgfamw3j28kw001nbnpw9c08"

import_config "prod.secret.exs"
