use Mix.Config

config :mission_control_ex,
  event_api_url: "http://staging-creative-mission-control-ex-env.mqwgbjhmmb.us-west-2.elasticbeanstalk.com/"

config :mission_control_ex, MissionControlEx.Web.Endpoint,
  http: [port: {:system, "PORT"}],
  url: [host: "example.com", port: 80],
  cache_static_manifest: "priv/static/cache_manifest.json"

config :mission_control_ex, MissionControlEx.Web.Repo,
  adapter: Ecto.Adapters.Postgres,
  database: "mission_control_ex_staging_db",
  username: "missioncontrol",
  password: "missioncontrol",
  hostname: "missioncontrol.cokyctnqdzct.us-west-2.rds.amazonaws.com",
  pool_size: 10


config :libcluster,
  topologies: [
    beanstalk_example: [
      strategy: BeanstalkGossipStrategy,
      config: [
        app_name: "streamer",
        beanstalk_environments: ["staging-creative-mission-control-ex-env", "stagingW-creative-mission-control-ex-env"],
        polling_interval: 60_000]]]
