job {
    name 'creative-mission-control-ex'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'creative/mission-control-ex', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    steps {
        shell './scripts/build.sh'
        shell './scripts/push.sh'
        saveDeployArtifact 'creative/mission-control-ex-ebextensions', 'deploy/'
        saveDeployArtifact 'creative/mission-control-exX-ebextensions', 'deployX/'
    }
}

freeStyleJob('creative-mission-control-ex-prod-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'creative-tcs-access-key'
            string 'AWS_SECRET_KEY', 'creative-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'creative/mission-control-ex-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/creative-mission-control-ex:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |    "AWSEBDockerrunVersion": 2,
                |    "volumes": [
                |      {
                |        "name": "media",
                |        "host": {
                |          "sourcePath": "/tmp"
                |        }
                |      }
                |    ],
                |    "containerDefinitions": [
                |        {
                |            "name": "daemon",
                |            "image": "\$IMAGE",
                |            "essential": true,
                |            "memory": 14000,
                |            "portMappings": [
                |                {
                |                    "hostPort": 80,
                |                    "containerPort": 80
                |                },
                |                {
                |                    "hostPort": 4369,
                |                    "containerPort": 4369
                |                },
                |                {
                |                    "hostPort": 9001,
                |                    "containerPort": 9001
                |                }
                |            ],
                |            "mountPoints": [
                |                {
                |                    "sourceVolume": "media",
                |                    "containerPath": "/media"
                |                }
                |            ]
                |        }
                |    ]
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy prod-creative-mission-control-ex-env""".stripMargin()
    }
}

freeStyleJob('creative-mission-control-ex-prodW-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'creative-tcs-access-key'
            string 'AWS_SECRET_KEY', 'creative-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'creative/mission-control-ex-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/creative-mission-control-ex:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |    "AWSEBDockerrunVersion": 2,
                |    "volumes": [
                |      {
                |        "name": "media",
                |        "host": {
                |          "sourcePath": "/tmp"
                |        }
                |      }
                |    ],
                |    "containerDefinitions": [
                |        {
                |            "name": "daemon",
                |            "image": "\$IMAGE",
                |            "essential": true,
                |            "memory": 14000,
                |            "portMappings": [
                |                {
                |                    "hostPort": 80,
                |                    "containerPort": 80
                |                },
                |                {
                |                    "hostPort": 4369,
                |                    "containerPort": 4369
                |                },
                |                {
                |                    "hostPort": 9001,
                |                    "containerPort": 9001
                |                }
                |            ],
                |            "mountPoints": [
                |                {
                |                    "sourceVolume": "media",
                |                    "containerPath": "/media"
                |                }
                |            ]
                |        }
                |    ]
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy prodW-creative-mission-control-ex-env""".stripMargin()
    }
}

freeStyleJob('creative-mission-control-ex-staging-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-creative-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-creative-dev-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'creative/mission-control-ex-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/creative-mission-control-ex:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |    "AWSEBDockerrunVersion": 2,
                |    "volumes": [
                |      {
                |        "name": "media",
                |        "host": {
                |          "sourcePath": "/tmp"
                |        }
                |      }
                |    ],
                |    "containerDefinitions": [
                |        {
                |            "name": "daemon",
                |            "image": "\$IMAGE",
                |            "essential": true,
                |            "memory": 14000,
                |            "portMappings": [
                |                {
                |                    "hostPort": 80,
                |                    "containerPort": 80
                |                },
                |                {
                |                    "hostPort": 4369,
                |                    "containerPort": 4369
                |                },
                |                {
                |                    "hostPort": 9001,
                |                    "containerPort": 9001
                |                }
                |            ],
                |            "mountPoints": [
                |                {
                |                    "sourceVolume": "media",
                |                    "containerPath": "/media"
                |                }
                |            ]
                |        }
                |    ]
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy staging-creative-mission-control-ex-env""".stripMargin()
    }
}

freeStyleJob('creative-mission-control-ex-stagingW-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-creative-dev-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-creative-dev-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'creative/mission-control-ex-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/creative-mission-control-ex:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |    "AWSEBDockerrunVersion": 2,
                |    "volumes": [
                |      {
                |        "name": "media",
                |        "host": {
                |          "sourcePath": "/tmp"
                |        }
                |      }
                |    ],
                |    "containerDefinitions": [
                |        {
                |            "name": "daemon",
                |            "image": "\$IMAGE",
                |            "essential": true,
                |            "memory": 14000,
                |            "portMappings": [
                |                {
                |                    "hostPort": 80,
                |                    "containerPort": 80
                |                },
                |                {
                |                    "hostPort": 4369,
                |                    "containerPort": 4369
                |                },
                |                {
                |                    "hostPort": 9001,
                |                    "containerPort": 9001
                |                }
                |            ],
                |            "mountPoints": [
                |                {
                |                    "sourceVolume": "media",
                |                    "containerPath": "/media"
                |                }
                |            ]
                |        }
                |    ]
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy stagingW-creative-mission-control-ex-env""".stripMargin()
    }
}

// prodX deploy

freeStyleJob('creative-mission-control-ex-prodX-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'creative-tcs-access-key'
            string 'AWS_SECRET_KEY', 'creative-tcs-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'creative/mission-control-exX-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/creative-mission-control-ex:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |    "AWSEBDockerrunVersion": 2,
                |    "volumes": [
                |      {
                |        "name": "media",
                |        "host": {
                |          "sourcePath": "/tmp"
                |        }
                |      }
                |    ],
                |    "containerDefinitions": [
                |        {
                |            "name": "daemon",
                |            "image": "\$IMAGE",
                |            "essential": true,
                |            "memory": 14000,
                |            "portMappings": [
                |                {
                |                    "hostPort": 80,
                |                    "containerPort": 80
                |                },
                |                {
                |                    "hostPort": 4369,
                |                    "containerPort": 4369
                |                },
                |                {
                |                    "hostPort": 9001,
                |                    "containerPort": 9001
                |                }
                |            ],
                |            "mountPoints": [
                |                {
                |                    "sourceVolume": "media",
                |                    "containerPath": "/media"
                |                }
                |            ]
                |        }
                |    ]
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy prodX-creative-mission-control-ex-env""".stripMargin()
    }
}
