defmodule ChatBotConnectionHandler do
  require Logger
  # This is a MissionControlEx.Web.Channel
  defstruct host: "irc.twitch.tv",
            port: 6667,
            channel: nil,
            clients: [],
            num_successful_connections: 0

  def start_link(clients, channel) do
    GenServer.start_link(__MODULE__, %__MODULE__{clients: clients, channel: channel})
  end

  def init(state) do
    Enum.each(state.clients, fn client ->
      ExIrc.Client.add_handler(client, self())
      GenServer.call(client, {:connect, state.host, state.port, [], false}, 5_000)
    end)

    {:ok, state}
  end

  # Connection and login related stuff
  def handle_info(
        {:connected, server, port},
        %{
          num_successful_connections: num_successful_connections,
          clients: clients,
          channel: %{login: login, oauth_token: pass}
        } = state
      )
      when num_successful_connections == length(clients) - 1 do
    Logger.info("All clients connected to #{server}:#{port}, logging in now", channel: login)

    Enum.each(state.clients, fn client ->
      ExIrc.Client.logon(client, "oauth:" <> pass, login, login, login)
      ExIrc.Client.remove_handler(client, self())
    end)

    {:noreply, state}
  end

  def handle_info(
        {:connected, _server, _port},
        %{num_successful_connections: num_successful_connections} = state
      ) do
    {:noreply, %{state | num_successful_connections: num_successful_connections + 1}}
  end

  # Catch-all for messages you don't care about
  # msg = {}
  def handle_info(msg, state) do
    Logger.info(
      "Received unknown messsage during connection process",
      channel: state.channel.login
    )

    # {:thing, text, info, channel} = msg
    {:noreply, state}
  end
end
