defmodule ChatBot.Supervisor do
  use Supervisor
  @name ChatBot.Supervisor

  def start_link() do
    Supervisor.start_link(__MODULE__, :ok, name: @name)
  end

  def start_chat_bot(opts) do
    Supervisor.start_child(@name, [opts])
  end

  def init(opts) do
    children = [
      worker(ChatBot, [], restart: :temporary)
    ]

    supervise(children, strategy: :simple_one_for_one)
  end
end
