defmodule MissionControlEx do
  use Application
  import Supervisor.Spec
  # See http://elixir-lang.org/docs/stable/elixir/Application.html
  # for more information on OTP Applications
  def start(_type, _args) do
    File.rm_rf("tmp/")
    Application.ensure_all_started(:hackney)
    Application.ensure_all_started(:ex_aws)
    # Define workers and child supervisors to be supervised
    children =
      [
        # Start the endpoint when the application starts
        supervisor(MissionControlEx.Web.Repo, []),
        supervisor(MissionControlEx.Web.Endpoint, []),
        supervisor(
          Task.Supervisor,
          [[name: MissionControlEx.Web.MessageSupervisor, restart: :transient, max_restarts: 4]],
          id: "message_supervisor"
        ),
        supervisor(
          Task.Supervisor,
          [[name: MissionControlEx.Web.OwnershipSupervisor, restart: :transient, max_restarts: 4]],
          id: "owner_supervisor"
        ),
        supervisor(
          Task.Supervisor,
          [
            [
              name: MissionControlEx.Web.GenericTranscodeSupervisor,
              restart: :transient,
              max_restarts: 4
            ]
          ],
          id: "generic_transcode_supervisor"
        ),
        supervisor(ConCache, [
          [
            ttl_check_interval: :timer.seconds(10),
            global_ttl: :timer.minutes(15)
          ],
          [name: :api_cache]
        ])
        # Start your own worker by calling: MissionControlEx.Web.Worker.start_link(arg1, arg2, arg3)
        # worker(GenPubsubServer, [MissionControlEx.Web.Endpoint]),
      ] ++ other_children(Mix.env(), System.get_env("DEV_MODE"))

    # See http://elixir-lang.org/docs/stable/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: MissionControlEx.Web.Supervisor]
    Supervisor.start_link(children, opts)
  end

  def other_children(env, dev_mode) do
    streamer_consumers(env, dev_mode) ++
      transcoder_consumers(env, dev_mode) ++ subtitle_searcher(env, dev_mode)
  end

  def streamer_consumers(:prod, _devmode), do: []
  def streamer_consumers(:staging, _devmode), do: []
  def streamer_consumers(:test, _), do: []
  def streamer_consumers(_env, "none"), do: []
  def streamer_consumers(_env, "transcoder"), do: []

  def streamer_consumers(_env, "streamer") do
    [
      supervisor(ChatBot.Supervisor, []),
      supervisor(StreamSupervisor, []),
      supervisor(MissionControlEx.Web.StreamScheduler.Supervisor, []),
      worker(MissionControlEx.Web.StreamScheduler.JobProducer, [])
    ] ++
      for id <- 1..2 do
        worker(MissionControlEx.Web.StreamScheduler.JobConsumer, [], id: {:streamer, id})
      end
  end

  def streamer_consumers(:prodW, _devmode), do: streamer_consumers(:prodW, "streamer")
  def streamer_consumers(:prodX, _devmode), do: streamer_consumers(:prodX, "streamer")
  def streamer_consumers(:stagingW, _devmode), do: streamer_consumers(:stagingW, "streamer")
  def streamer_consumers(_env, _devmode), do: []

  def transcoder_consumers(:prodW, _devmode), do: []
  def transcoder_consumers(:prodX, _devmode), do: []
  def transcoder_consumers(:test, _), do: []
  def transcoder_consumers(:stagingW, _), do: []
  def transcoder_consumers(_env, "none"), do: []
  def transcoder_consumers(_env, "streamer"), do: []

  def transcoder_consumers(_env, "transcoder") do
    [
      worker(MissionControlEx.Web.TranscoderJobProducer, []),
      supervisor(MissionControlEx.Web.TranscoderJobConsumer, [])
    ]
  end

  def transcoder_consumers(:prod, _devmode), do: transcoder_consumers(:prod, "transcoder")
  def transcoder_consumers(:staging, _devmode), do: transcoder_consumers(:staging, "transcoder")
  def transcoder_consumers(_env, _devmode), do: []

  def subtitle_searcher(_env, "none"), do: []
  def subtitle_searcher(_env, "searcher"), do: [supervisor(AssetSubtitleSearch, [])]
  def subtitle_searcher(:prod, _devmode), do: subtitle_searcher(:prod, "searcher")
  def subtitle_searcher(:staging, _devmode), do: subtitle_searcher(:staging, "searcher")
  def subtitle_searcher(_env, _devmode), do: []
end
