defmodule MissionControlEx.Web.AdInterface do
  use HTTPoison.Base
  require Logger

  @ad_durations [
    30_000,
    60_000,
    90_000,
    120_000,
    150_000,
    180_000,
    210_000,
    240_000,
    270_000,
    300_000,
    330_000,
    360_000,
    390_000,
    420_000,
    450_000,
    480_000
  ]
  @min_ad_duration 30_000

  def process_url(channel_identifier) do
    "https://api.twitch.tv/kraken/channels/" <> "#{channel_identifier}" <> "/commercial"
  end

  def post(channel, play_duration_ms) do
    duration = get_ad_duration(play_duration_ms)
    Logger.info("Posting ad to channel of duration #{duration}", channel: channel.login)

    headers = [
      {"Accept-Encoding", "gzip, deflate, sdch, br"},
      {"Authorization", "OAuth #{channel.oauth_token}"},
      {"Content-Type", "application/json"},
      {"Client-ID", "jzkbprff40iqj646a697cyrvl0zt2m6"}
    ]

    {:ok, response} =
      HTTPoison.post(process_url(channel.login), "{\"duration\": #{duration}}", headers)

    case response.status_code do
      code when 200 <= code and code < 300 ->
        Logger.info("Ad posted successfully", channel: channel.login)

      code ->
        Logger.info("Ad post failed, returned status code #{code}", channel: channel.login)
    end
  end

  def get_ad_duration(duration) do
    ad_duration_ms =
      Enum.find(@ad_durations, fn ad_duration -> duration - ad_duration < @min_ad_duration end)

    round(ad_duration_ms / 1000)
  end
end
