defmodule MissionControlEx.Web.CaptionsServer do
  def start_link do
    Agent.start_link(fn -> [] end, name: __MODULE__)
  end

  @doc "say hello"
  def hello() do
    Agent.get(__MODULE__, fn _ -> "Hello!" end)
  end

  @doc "begin combining src movie and subtitles for closed captions"
  def create_captions(src_url, sub_url) do
    caption = %{
      :src_url => src_url,
      :sub_url => sub_url,
      :cc_url => '',
      :completed => false
    }

    Agent.update(__MODULE__, fn captions -> captions ++ [caption] end)
  end
end
