defmodule StreamEventBlock do
  defstruct [:schedule_manager, :stream_schedule, :event]
  alias MissionControlEx.Web.{Event, ScheduleManager}

  def event_block_reduce(
        event,
        {
          stream_schedule,
          %StreamManagerBlock{
            schedule_manager: schedule_manager,
            time_after_events: event_time,
            chunk_index: chunk_index
          }
        }
      ) do
    time_after_event =
      Timex.add(event_time, Timex.Duration.from_milliseconds(Event.duration(event)))

    current_index =
      case stream_schedule.played_event_chunks do
        [%{events: events} | _] when length(events) > chunk_index + 1 ->
          chunk_index

        _ ->
          nil
      end

    stream_schedule = %{stream_schedule | chunk_index: current_index}

    schedule_manager =
      %{schedule_manager | events: schedule_manager.events ++ [event]}
      |> ScheduleManager.with_stream_schedule(stream_schedule)

    {
      %StreamEventBlock{
        schedule_manager: schedule_manager,
        stream_schedule: stream_schedule,
        event: event
      },
      {
        stream_schedule,
        %StreamManagerBlock{
          schedule_manager: schedule_manager,
          time_after_events: time_after_event,
          chunk_index: chunk_index + 1
        }
      }
    }
  end
end
