defmodule StreamEventChunkBlock do
  defstruct [:schedule_manager, :stream_schedule, :event_chunk]
  alias MissionControlEx.Web.{Event, ScheduleManager}

  # Helper function to break down chunk blocks to individual event blocks
  def to_stream_event_blocks(
        %{
          stream_schedule: stream_schedule,
          event_chunk: %{events: events},
          schedule_manager: manager
        } = event_chunk_block,
        %StreamManagerBlock{schedule_manager: %{events: current_events}} = manager_block
      ) do
    manager = %{manager | events: current_events}
    manager_block = %{manager_block | schedule_manager: manager}

    {event_blocks, {_, manager_block}} =
      Enum.map_reduce(
        events,
        {stream_schedule, manager_block},
        &StreamEventBlock.event_block_reduce/2
      )

    {event_blocks, %{manager_block | chunk_index: 0}}
  end
end
