defmodule Silence do
  def probe_silence(movie) do
    {json, _} =
      System.cmd(
        "ffprobe",
        [
          "-f",
          "lavfi",
          "-i",
          "amovie=#{movie},silencedetect",
          "-show_frames",
          "-show_streams",
          "-of",
          "json",
          "-v",
          "quiet"
        ],
        parallelism: true
      )

    {_, list} = json |> Poison.decode()
    silence_frames = list["frames"] |> Enum.filter(fn frame -> frame["tags"] end)

    # silence_frames |> Enum.at(1) |> Map.get("tags", %{}) |> Map.get("lavfi.silence_end", "0")
    start_time = get_silence_time(silence_frames, "lavfi.silence_end")
    # |> List.last |> Map.get("tags", %{}) |> Map.get("lavfi.silence_start", "0")
    end_time = get_silence_time(silence_frames, "lavfi.silence_start")

    {start, _} = Float.parse(start_time)

    {start, calc_duration(start_time, end_time)}
  end

  def get_silence_time(silence_frames, key) do
    frames =
      case key do
        "lavfi.silence_end" -> silence_frames
        "lavfi.silence_start" -> silence_frames |> Enum.reverse()
      end

    time =
      frames
      |> Enum.find_value(fn frame -> frame |> Map.get("tags", %{}) |> Map.get(key, nil) end)

    case time do
      nil -> "0"
      _ -> time
    end
  end

  def calc_duration("0", "0"), do: :no_end_silence
  def calc_duartion(_start_ts, "0"), do: :no_end_silence

  def calc_duartion("0", end_ts) do
    {fin, _} = Float.parse(end_ts)
    fin
  end

  def calc_duration(start_ts, end_ts) do
    {start, _} = Float.parse(start_ts)
    {fin, _} = Float.parse(end_ts)
    fin - start
  end
end
