defmodule StreamSupervisor do
  use Supervisor

  def start_link do
    Supervisor.start_link(__MODULE__, :ok, name: StreamSupervisor)
  end

  def start_stream(channel) do
    Supervisor.start_child(StreamSupervisor, [channel])
  end

  def init(:ok) do
    children = [
      worker(Streamer, [], restart: :temporary)
    ]

    supervise(children, strategy: :simple_one_for_one)
  end
end
