defmodule MissionControlEx.Web.CaptionsChannel do
  use MissionControlEx.Web, :channel

  alias MissionControlEx.Web.CaptionsServer

  def join("captions:default", _params, socket) do
    # msg = CaptionsServer.hello()
    {:ok, %{captions: "OK"}, socket}
  end

  def join("captions:" <> some_id, _params, socket) do
    {:ok, socket}
  end

  def process_ffmpeg_log(line) do
    MissionControlEx.Web.Endpoint.broadcast!("captions:default", "ADD_LOG_LINE", %{line: line})
    # {:ok, socket}
  end

  def handle_in("new:caption", params, socket) do
    IO.inspect(params)

    CaptionsServer.add(params)

    broadcast!(socket, "new:caption", %{
      caption: params
    })

    {:noreply, socket}
  end
end
