defmodule MissionControlEx.Web.AuthController do
  use MissionControlEx.Web, :controller
  plug(Ueberauth)
  alias MissionControlEx.Web.Channel

  def callback(conn, _) do
    case Channel.create_from_oauth(conn.assigns.ueberauth_auth) do
      {:ok, struct} ->
        redirect(conn, to: channel_path(conn, :index))
    end
  end
end
