defmodule MissionControlEx.Web.ChatCommandController do
  use MissionControlEx.Web, :controller

  alias MissionControlEx.Web.ChatCommand

  def index(conn, _params) do
    chat_commands = Repo.all(ChatCommand)
    render(conn, "index.html", chat_commands: chat_commands)
  end

  def new(conn, _params) do
    changeset = ChatCommand.changeset(%ChatCommand{})
    render(conn, "new.html", changeset: changeset)
  end

  def create(conn, %{"chat_command" => chat_command_params}) do
    changeset = ChatCommand.changeset(%ChatCommand{}, chat_command_params)

    case Repo.insert(changeset) do
      {:ok, chat_command} ->
        conn
        |> put_flash(:info, "Chat command created successfully.")
        |> redirect(to: chat_command_path(conn, :show, chat_command))

      {:error, changeset} ->
        render(conn, "new.html", changeset: changeset)
    end
  end

  def show(conn, %{"id" => id}) do
    chat_command = Repo.get!(ChatCommand, id)
    render(conn, "show.html", chat_command: chat_command)
  end

  def edit(conn, %{"id" => id}) do
    chat_command = Repo.get!(ChatCommand, id)
    changeset = ChatCommand.changeset(chat_command)
    render(conn, "edit.html", chat_command: chat_command, changeset: changeset)
  end

  def update(conn, %{"id" => id, "chat_command" => chat_command_params}) do
    chat_command = Repo.get!(ChatCommand, id)
    changeset = ChatCommand.changeset(chat_command, chat_command_params)

    case Repo.update(changeset) do
      {:ok, chat_command} ->
        conn
        |> put_flash(:info, "Chat command updated successfully.")
        |> redirect(to: chat_command_path(conn, :show, chat_command))

      {:error, changeset} ->
        render(conn, "edit.html", chat_command: chat_command, changeset: changeset)
    end
  end

  def delete(conn, %{"id" => id}) do
    chat_command = Repo.get!(ChatCommand, id)

    # Here we use delete! (with a bang) because we expect
    # it to always work (and if it does not, it will raise).
    Repo.delete!(chat_command)

    conn
    |> put_flash(:info, "Chat command deleted successfully.")
    |> redirect(to: chat_command_path(conn, :index))
  end
end
