defmodule MissionControlEx.Web.EventController do
  use MissionControlEx.Web, :controller
  alias MissionControlEx.Web.{StreamSchedule, Event, ScheduleManager}

  action_fallback(MissionControlEx.Web.FallbackController)

  def process_and_persist_event(conn, %{"event" => event}) do
    with %Event{} = event <- Event.process_persist_update(Poison.encode!(event)),
         do: render(put_status(conn, 204), "event.json", event: event)
  end
end
