defmodule MissionControlEx.Web.FallbackController do
  use MissionControlEx.Web, :controller
  alias MissionControlEx.Web.{Schedule.ScheduleInvalidError}

  def call(conn, {:preview_error, error}) do
    conn
    |> put_status(422)
    |> render(MissionControlEx.Web.ErrorView, "preview_error.json", error: error)
  end

  def call(conn, {:invalid_csv_schedule, error}) do
    conn
    |> put_status(422)
    |> render(MissionControlEx.Web.ErrorView, "preview_error.json", error: error)
  end

  def call(conn, {:error, %Ecto.Changeset{} = changeset}) do
    changeset_errors =
      Ecto.Changeset.traverse_errors(changeset, fn {msg, opts} ->
        Enum.reduce(opts, msg, fn {key, value}, acc ->
          String.replace(acc, "%{#{key}}", to_string(value))
        end)
      end)

    conn
    |> put_status(422)
    |> render(
         MissionControlEx.Web.ErrorView,
         "changeset_error.json",
         changeset_errors: changeset_errors
       )
  end

  def call(conn, {:noop, stream_schedule, event}) do
    stream_schedule =
      Map.drop(stream_schedule, [:queued_event_chunks, :played_event_chunks, :events])

    Utils.rollbar_report_warning(
      "Event does not exist on stream schedule #{stream_schedule.name} (id: #{stream_schedule.id}): #{
        Poison.encode!(event)
      }",
      %{event: event}
    )

    conn
    |> put_status(422)
    |> render(MissionControlEx.Web.ErrorView, "event_persist_error.json", %{event: event})
  end

  def call(conn, {:error, _error}) do
    conn
    |> put_status(404)
    |> render(MissionControlEx.Web.ErrorView, "404.json")
  end

  def call(conn, {:curator_url_error, _error}) do
    conn
    |> put_status(404)
    |> render(MissionControlEx.Web.ErrorView, "404.json")
  end
end
