defmodule MissionControlEx.Web.InterstitialController do
  use MissionControlEx.Web, :controller
  alias ExAws.S3
  alias MissionControlEx.Web.Asset
  alias MissionControlEx.Web.GenericTranscodeSupervisor
  @video_bucket "twitch-creative-video-repository"

  def new(conn, _params) do
    render(conn, "new.html", changeset: %{})
  end

  def create(
        conn,
        %{
          "interstitial" => %{
            "source_audio" => source_audio,
            "source_image" => source_image,
            "filename" => filename,
            "duration" => duration
          }
        } = params
      ) do
    Task.Supervisor.async_nolink(GenericTranscodeSupervisor, fn ->
      generate_asset(source_audio.path, source_image.path, filename, duration)
    end)

    conn
    |> put_flash(
         :info,
         "Your interstitial is being prepared and will live on prod_raw/interstitials/#{filename}.mp4 Should be done cooking in 5 minutes tops give or take a few."
       )
    |> render("new.html", changeset: %{})
  end

  def generate_asset(source_audio, source_image, filename, duration) do
    {:ok, audio_path} = Briefly.create(extname: ".mp3")

    %{status: 0} =
      Porcelain.shell(
        "ffmpeg -y -t #{duration} -stream_loop 100 -i #{source_audio} -c copy #{audio_path}",
        err: :out
      )

    {:ok, video_path} = Briefly.create(extname: ".mp4")

    %{status: 0} =
      Porcelain.shell(
        "ffmpeg -y -loop 1 -i #{source_image} -i #{audio_path} -t #{duration} -r 60 -c:v libx264 -c:a aac -shortest #{
          video_path
        }",
        err: :out
      )

    :done =
      video_path
      |> S3.Upload.stream_file()
      |> S3.upload(@video_bucket, "prod_raw/interstitials/#{filename}.mp4")
      |> ExAws.request!()
  end
end
