defmodule MissionControlEx.Web.ManifestController do
  use MissionControlEx.Web, :controller

  alias MissionControlEx.Web.{Manifest, Asset}

  @exaws_s3_config ExAws.Config.new(:s3, %{
                     access_key_id: "AKIAJ4RHGC5TBNDDSR3A",
                     secret_access_key: "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"
                   })

  def index(conn, _params) do
    manifests =
      Repo.all(Manifest)
      |> Repo.preload(:assets)
      |> Enum.map(&Manifest.add_progress/1)

    render(conn, "index.html", manifest: manifests)
  end

  def new(conn, _params) do
    changeset = Manifest.changeset(%Manifest{})
    render(conn, "new.html", changeset: changeset)
  end

  def create(conn, %{"manifest" => manifest_params}) do
    changeset = Manifest.csv_to_manifest(%Manifest{}, manifest_params)

    with {:ok, manifest} <- Manifest.new_manifest(changeset) do
      conn
      |> put_flash(:info, "Manifest and Twitch Stream created successfully.")
      |> redirect(to: manifest_path(conn, :show, Manifest.load(manifest)))
    else
      {:error, error} ->
        conn
        |> put_flash(:error, "Something went wrong! CSV may not be properly formatted.")
        |> render("new.html", changeset: changeset)
    end
  end

  def show(conn, %{"id" => id}) do
    manifest = Manifest.load(id)
    render(conn, "show.html", manifest: manifest)
  end

  def edit(conn, %{"id" => id}) do
    manifest = Repo.get!(Manifest, id)
    changeset = Manifest.changeset(manifest)
    render(conn, "edit.html", manifest: manifest, changeset: changeset)
  end

  def update(conn, %{"id" => id, "manifest" => manifest_params}) do
    manifest = Manifest.load(id)
    changeset = Manifest.csv_to_manifest(manifest, manifest_params)

    case Repo.update(changeset) do
      {:ok, manifest} ->
        {:ok, _} = Manifest.create_transcode_jobs(manifest)

        conn
        |> put_flash(:info, "Manifest updated successfully.")
        |> redirect(to: manifest_path(conn, :show, manifest))

      {:error, changeset} ->
        render(conn, "edit.html", manifest: manifest, changeset: changeset)
    end
  end

  def delete(conn, %{"id" => id}) do
    manifest = Repo.get!(Manifest, id)

    # Here we use delete! (with a bang) because we expect
    # it to always work (and if it does not, it will raise).
    Repo.delete!(manifest)

    conn
    |> put_flash(:info, "Manifest deleted successfully.")
    |> redirect(to: manifest_path(conn, :index))
  end

  def s3_manifest(conn, _params) do
    changeset = Manifest.changeset(%Manifest{})
    render(conn, "s3_to_manifest.html", changeset: changeset)
  end

  def s3_assets(conn, %{"s3_path" => s3_path, "filter_out" => filter_out} = params) do
    filters =
      String.split(filter_out, ",")
      |> Enum.map(&String.trim(&1))
      |> Enum.reject(&(&1 == ""))

    s3_path = String.trim(s3_path)

    asset_stream =
      ExAws.S3.list_objects("twitch-creative-video-repository", prefix: s3_path)
      |> ExAws.stream!(@exaws_s3_config)
      |> Stream.map(& &1.key)
      |> Stream.filter(&(Utils.get_type(&1) in [:video, :subtitles]))
      |> Stream.reject(&String.contains?(&1, filters))

    %{video: videos, subtitles: captions} =
      Map.merge(%{video: [], subtitles: []}, Enum.group_by(asset_stream, &Utils.get_type/1))

    best_guess =
      videos
      |> Enum.map(fn video ->
           Enum.find(captions, "None_Required", fn caption ->
             String.replace(filename(caption), "captions", "") ==
               String.replace(filename(video), "episode", "")
           end)
         end)

    data = %{videos: videos, captions: captions, best_guess: best_guess}

    json(conn, data)
  end

  def export_manifest(conn, %{"id" => id}) do
    {manifest, csv} = Manifest.manifest_to_csv(id)

    conn
    |> put_resp_content_type("text/csv")
    |> put_resp_header(
         "content-disposition",
         "attachment; filename=\"#{manifest.name || "manifest_#{manifest.id}"}.csv\""
       )
    |> send_resp(200, csv)
  end

  def export_csv(conn, params) do
    conn
    |> put_resp_content_type("text/csv")
    |> put_resp_header(
         "content-disposition",
         "attachment; filename=\"#{params["name"] || "generic"}.csv\""
       )
    |> send_resp(200, csv_content(params))
  end

  defp csv_content(%{"asset" => assets, "name" => name} = params) do
    GenerateTranscodeJobs.create_csv(assets, %{"name" => name})
    |> Enum.to_list()
    |> to_string
  end

  defp csv_content(_params), do: ""

  defp filename(path), do: Path.rootname(Path.basename(path))
end
