defmodule MissionControlEx.Web.PageController do
  use MissionControlEx.Web, :controller

  def index(conn, _params) do
    conn
    |> assign(:live_streams, fetch_live_streams())
    |> render("index.html")
  end

  def transcoder(conn, _params) do
    render(conn, "transcoder.html")
  end

  def fetch_live_streams() do
    :global.registered_names()
    |> Enum.filter(fn
         {:stream, _} -> true
         _ -> false
       end)
    |> Enum.map(fn pid -> Streamer.get_state({:global, pid}) end)
  end
end
