defmodule FFMpeger do
  # Generic get_video_bytes for assets with known duration and URLs to mp4's/mpegts's
  def get_video_bytes(url, start_time_ms, duration_ms, options \\ []) do
    start_time = :erlang.float_to_binary(start_time_ms / 1000, decimals: 3)
    duration = :erlang.float_to_binary(duration_ms / 1000, decimals: 3)

    # Bug in ffmpeg requires offset of less than 0.5 to be ommited
    ss_flags =
      case start_time do
        start_time when start_time < 0.500 -> ""
        start_time -> "-ss #{start_time}"
      end

    opts = [out: :stream, err: nil]
    # opts = opts ++ [env: %{"FFREPORT" => "file=/Users/$USER/logs/buffer-\%p-\%t.log"}]
    %{out: stream} =
      Porcelain.spawn_shell(
        """
        ffmpeg #{ss_flags} -threads 2 -i \"#{url}\" -to #{duration} -c copy -f mpegts - | \
        pv -q -L 100m
        """,
        opts
      )

    stream
  end

  # Live downloads asset from webpage using youtube-dl, used for curated mode
  def get_video_bytes_from_web_page(url) do
    opts = [out: :stream, err: nil]
    # opts = opts ++ [env: %{"FFREPORT" => "file=/Users/$USER/logs/buffer-\%p-\%t.log"}]
    IO.inspect(url, label: "trying to youtubedl and stream from this url")

    %{out: stream} =
      Porcelain.spawn_shell(
        """
        youtube-dl --no-continue -f \"mp4\" -o - \"#{url}\" | \
        ffmpeg -y -i - \
        -c:v libx264 -preset:v veryfast -crf 13 -pix_fmt yuv420p -threads 0 -r 30 -fflags +genpts \
        -c:a aac -b:a 48k -ar 48000 -ac 2 \
        -f mpegts -
        """,
        opts
      )

    stream
  end

  # Streams clips
  def stream_clip(url, clip_data, overlay_path) do
    opts = [out: :stream, err: nil]
    # opts = opts ++ [env: %{"FFREPORT" => "file=/Users/$USER/logs/buffer-\%p-\%t.log"}]
    overlay_path = generate_curator_overlay(clip_data, overlay_path)

    %{out: stream} =
      Porcelain.spawn_shell(
        """
        youtube-dl --no-continue -f \"mp4\" -o - \"#{url}\" | \
        ffmpeg -y -i - -itsoffset 1.25 -i \"#{overlay_path}\" \
        -filter_complex \"[1:v]colorkey=black[t];[0:v]scale=1920:1080[s];[s][t]overlay=15:main_h-overlay_h-15:eof_action=pass[out]\" \
        -map \'[out]\' -map 0:a:0 \
        -c:v libx264 -preset:v veryfast -crf 13 -pix_fmt yuv420p -threads 0 -r 30 -fflags +genpts \
        -c:a aac -b:a 48k -ar 48000 -ac 2 \
        -f mpegts -
        """,
        opts
      )

    stream
  end

  # Generates overlays for clips
  def generate_curator_overlay(
        %{"slug" => clip_id, "curator" => curator, "broadcaster" => broadcaster} = clip_data,
        overlay_path
      ) do
    string_fade =
      "fontcolor_expr=0xFFFFFF%{eif\\\\: clip(255*(1*between(t\\, 0.8 + 0.3\\, 4.5 - 0.5) + ((t - 0.8)/0.3)*between(t\\, 0.8\\, 0.8 + 0.3) + (-(t - 4.5)/0.5)*between(t\\, 4.5 - 0.5\\, 4.5) )\\, 0\\, 255) \\\\: x\\\\: 2 }"

    # Broadcaster name string
    string_1 =
      "drawtext=fontfile=#{System.cwd!()}/assets/Korolev_bold.otf:fontsize=45:x=150:y=27:text='twitch.tv/#{
        get_latin_name(broadcaster)
      }':"

    # 'ascent' is used for the full potential text height. Works great to keep text centered regardless of y's and C's
    string_2 =
      "drawtext=fontfile=#{System.cwd!()}/assets/Korolev_Light.otf:fontsize=27:x=150:y=103-ascent:text='Clipped by':"

    # Clipper name string
    string_3 =
      "drawtext=fontfile=#{System.cwd!()}/assets/Korolev_bold.otf:fontsize=27:x=278:y=103-ascent:text='#{
        get_latin_name(curator)
      }':"

    {_, 0} =
      System.cmd(
        "ffmpeg",
        [
          "-y",
          "-i",
          "assets/overlay_purple.webm",
          "-vf",
          "#{
            string_1 <>
              string_fade <> "," <> string_2 <> string_fade <> "," <> string_3 <> string_fade
          }",
          "-r",
          "30",
          overlay_path
        ],
        stderr_to_stdout: true
      )

    overlay_path
  end

  # Clip overlay helper functions
  def get_latin_name(%{"display_name" => display_name, "name" => name}) do
    if is_latin_string?(display_name), do: display_name, else: name
  end

  def is_latin_string?(string) do
    all_latin_regex = ~r/\p{Latin}|\p{Common}/u
    latin_chars = Regex.scan(all_latin_regex, string)
    length(latin_chars) == String.length(string)
  end
end
