defmodule ScrapeS3 do
  alias Porcelain
  alias Procelain.Result
  alias ExAws.S3
  require MissionControlEx.Web.CaptionsChannel
  require Utils

  @refresh_every 1
  defstruct [:percentage, :callback_pid, :asset]

  def perform(input_url, output_s3_path) do
    case ScrapeS3.start_link(input_url, output_s3_path, self()) do
      {:ok, _} ->
        receive do
          :complete -> nil
        end

      :ignore ->
        nil
    end
  end

  use GenServer

  def start_link(input_url, output_s3_path, callback_pid) do
    GenServer.start_link(ScrapeS3, {input_url, output_s3_path, callback_pid})
  end

  def init({input_url, output_s3_path, callback_pid} = state) do
    case S3.head_object("twitch-creative-video-repository", output_s3_path)
         |> ExAws.request(
              ExAws.Config.new(:s3, %{
                access_key_id: "AKIAJ4RHGC5TBNDDSR3A",
                secret_access_key: "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"
              })
            ) do
      {:ok, _} ->
        :ignore

      {:error, _} ->
        {:ok, local_path} = Briefly.create(extname: ".mov")
        opts = [err: :out, out: {:send, self}]
        proc = Porcelain.spawn_shell("wget \"#{input_url}\" -O \"#{local_path}\"", opts)
        {:ok, {input_url, output_s3_path, callback_pid, local_path}}
    end
  end

  def handle_info({_from, :data, :out, line}, state) do
    IO.inspect(line)

    if String.contains?(line, "%") do
    end

    {:noreply, state}
  end

  def handle_info(
        {pid, :result, %Porcelain.Result{err: :out, out: {:send, self}, status: 0}} = msg,
        {input_url, output_s3_path, callback_pid, local_path} = state
      ) do
    IO.inspect({"got weird message", msg})

    Task.async(fn ->
      local_path
      |> S3.Upload.stream_file()
      |> S3.upload("twitch-creative-video-repository", output_s3_path)
      |> IO.inspect()
      |> ExAws.request!(
           ExAws.Config.new(:s3, %{
             access_key_id: "AKIAJ4RHGC5TBNDDSR3A",
             secret_access_key: "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"
           })
         )

      send(callback_pid, :complete)
    end)

    {:noreply, state}
  end

  def handle_info({_, :complete}, _state), do: {:stop, :normal, :done}

  def handle_info(
        {pid, :result, %Porcelain.Result{err: :out, out: {:send, self}, status: _}},
        state
      ) do
    {:stop, :scrape_failed, :errored}
  end
end
